/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_downsample3D")
public class Downsample3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        float downsampleX = Downsample3D.asFloat((Object)this.args[2]).floatValue();
        float downsampleY = Downsample3D.asFloat((Object)this.args[3]).floatValue();
        float downsampleZ = Downsample3D.asFloat((Object)this.args[4]).floatValue();
        return this.getCLIJ2().downsample((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), downsampleX, downsampleY, downsampleZ);
    }

    @Deprecated
    public static boolean downsample3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float factorX, Float factorY, Float factorZ) {
        return Downsample3D.downsample(clij2, src, dst, factorX, factorY, factorZ);
    }

    @Deprecated
    public static boolean downsample(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float factorX, Float factorY, Float factorZ) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("factor_x", Float.valueOf(1.0f / factorX.floatValue()));
        parameters.put("factor_y", Float.valueOf(1.0f / factorY.floatValue()));
        parameters.put("factor_z", Float.valueOf(1.0f / factorZ.floatValue()));
        clij2.execute(Downsample3D.class, "downsample_3d_x.cl", "downsample_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number factorX, Number factorY, Number factorZ";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        float downsampleX = Downsample3D.asFloat((Object)this.args[2]).floatValue();
        float downsampleY = Downsample3D.asFloat((Object)this.args[3]).floatValue();
        float downsampleZ = Downsample3D.asFloat((Object)this.args[4]).floatValue();
        return this.getCLIJ2().create(new long[]{(long)((float)input.getWidth() * downsampleX), (long)((float)input.getHeight() * downsampleY), (long)((float)input.getDepth() * downsampleZ)}, input.getNativeType());
    }

    public String getDescription() {
        return "Scales an image using given scaling factors for X and Y dimensions. \n\nThe nearest-neighbor method\nis applied. In ImageJ the method which is similar is called 'Interpolation method: none'.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

