/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_drawBox")
public class DrawBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public Object[] getDefaultValues() {
        return new Object[]{null, 0, 0, 0, 10, 10, 10, 255};
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, Number x, Number y, Number z, Number width, Number height, Number depth, Number value";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        Float x = DrawBox.asFloat((Object)this.args[1]);
        Float y = DrawBox.asFloat((Object)this.args[2]);
        Float z = DrawBox.asFloat((Object)this.args[3]);
        Float width = DrawBox.asFloat((Object)this.args[4]);
        Float height = DrawBox.asFloat((Object)this.args[5]);
        Float depth = DrawBox.asFloat((Object)this.args[6]);
        Float value = DrawBox.asFloat((Object)this.args[7]);
        return this.getCLIJ2().drawBox((ClearCLImageInterface)input, x.floatValue(), y.floatValue(), z.floatValue(), width.floatValue(), height.floatValue(), depth.floatValue(), value.floatValue());
    }

    public static boolean drawBox(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float z, Float width, Float height, Float depth) {
        return DrawBox.drawBox(clij2, output, x, y, z, width, height, depth, Float.valueOf(1.0f));
    }

    public static boolean drawBox(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float z, Float width, Float height, Float depth, Float value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x1", x);
        parameters.put("y1", y);
        parameters.put("x2", Float.valueOf(x.floatValue() + width.floatValue()));
        parameters.put("y2", Float.valueOf(y.floatValue() + height.floatValue()));
        if (output.getDimension() > 2L) {
            parameters.put("z1", z);
            parameters.put("z2", Float.valueOf(z.floatValue() + depth.floatValue()));
        }
        parameters.put("dst", output);
        parameters.put("value", value);
        clij2.execute(DrawBox.class, "draw_box_" + output.getDimension() + "d_x.cl", "draw_box_" + output.getDimension() + "d", output.getDimensions(), output.getDimensions(), parameters);
        return true;
    }

    public static boolean drawBox(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float width, Float height) {
        return DrawBox.drawBox(clij2, output, x, y, Float.valueOf(0.0f), width, height, Float.valueOf(0.0f));
    }

    public String getDescription() {
        return "Draws a box at a given start point with given size. \nAll pixels other than in the box are untouched. Consider using `set(buffer, 0);` in advance.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Visualisation";
    }
}

