/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_drawLine")
public class DrawLine
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public Object[] getDefaultValues() {
        return new Object[]{null, 0, 0, 0, 10, 10, 10, 1, 255};
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, Number x1, Number y1, Number z1, Number x2, Number y2, Number z2, Number thickness, Number value";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        Float x1 = DrawLine.asFloat((Object)this.args[1]);
        Float y1 = DrawLine.asFloat((Object)this.args[2]);
        Float z1 = DrawLine.asFloat((Object)this.args[3]);
        Float x2 = DrawLine.asFloat((Object)this.args[4]);
        Float y2 = DrawLine.asFloat((Object)this.args[5]);
        Float z2 = DrawLine.asFloat((Object)this.args[6]);
        Float thickness = DrawLine.asFloat((Object)this.args[7]);
        Float value = DrawLine.asFloat((Object)this.args[8]);
        return this.getCLIJ2().drawLine((ClearCLImageInterface)input, x1.floatValue(), y1.floatValue(), z1.floatValue(), x2.floatValue(), y2.floatValue(), z2.floatValue(), thickness.floatValue(), value.floatValue());
    }

    public static boolean drawLine(CLIJ2 clij2, ClearCLImageInterface output, Float x1, Float y1, Float z1, Float x2, Float y2, Float z2, Float thickness) {
        return DrawLine.drawLine(clij2, output, x1, y1, z1, x2, y2, z2, thickness, Float.valueOf(1.0f));
    }

    public static boolean drawLine(CLIJ2 clij2, ClearCLImageInterface output, Float x1, Float y1, Float z1, Float x2, Float y2, Float z2, Float thickness, Float value) {
        long[] globalSizes;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x1", x1);
        parameters.put("y1", y1);
        parameters.put("x2", x2);
        parameters.put("y2", y2);
        if (output.getDimension() > 2L) {
            parameters.put("z1", z1);
            parameters.put("z2", z2);
            globalSizes = new long[]{(long)(Math.abs(x1.floatValue() - x2.floatValue()) + 1.0f + thickness.floatValue()), (long)(Math.abs(y1.floatValue() - y2.floatValue()) + 1.0f + thickness.floatValue()), (long)(Math.abs(z1.floatValue() - z2.floatValue()) + 1.0f + thickness.floatValue())};
        } else {
            globalSizes = new long[]{(long)(Math.abs(x1.floatValue() - x2.floatValue()) + 1.0f + thickness.floatValue()), (long)(Math.abs(y1.floatValue() - y2.floatValue()) + 1.0f + thickness.floatValue())};
        }
        parameters.put("radius", new Float(thickness.floatValue() / 2.0f));
        parameters.put("dst", output);
        parameters.put("value", value);
        clij2.execute(DrawLine.class, "drawline_" + output.getDimension() + "d_x.cl", "draw_line_" + output.getDimension() + "D", globalSizes, globalSizes, parameters);
        return true;
    }

    public String getDescription() {
        return "Draws a line between two points with a given thickness. \n\nAll pixels other than on the line are untouched. Consider using `set(buffer, 0);` in advance.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Visualisation";
    }
}

