/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_drawSphere")
public class DrawSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public Object[] getDefaultValues() {
        return new Object[]{null, 5, 5, 5, 3, 3, 3, 255};
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, Number x, Number y, Number z, Number radius_x, Number radius_y, Number radius_z, Number value";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        Float x = DrawSphere.asFloat((Object)this.args[1]);
        Float y = DrawSphere.asFloat((Object)this.args[2]);
        Float z = DrawSphere.asFloat((Object)this.args[3]);
        Float rX = DrawSphere.asFloat((Object)this.args[4]);
        Float rY = DrawSphere.asFloat((Object)this.args[5]);
        Float rZ = DrawSphere.asFloat((Object)this.args[6]);
        Float value = DrawSphere.asFloat((Object)this.args[7]);
        return this.getCLIJ2().drawSphere((ClearCLImageInterface)input, x.floatValue(), y.floatValue(), z.floatValue(), rX.floatValue(), rY.floatValue(), rZ.floatValue(), value.floatValue());
    }

    public static boolean drawSphere(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float z, Float rx, Float ry, Float rz) {
        return DrawSphere.drawSphere(clij2, output, x, y, z, rx, ry, rz, Float.valueOf(1.0f));
    }

    public static boolean drawSphere(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float z, Float rx, Float ry, Float rz, Float value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("cx", x);
        parameters.put("cy", y);
        parameters.put("rx", rx);
        parameters.put("ry", ry);
        parameters.put("rxsq", new Float(Math.pow(rx.floatValue(), 2.0)));
        parameters.put("rysq", new Float(Math.pow(ry.floatValue(), 2.0)));
        System.out.print("rxsq " + parameters.get("rxsq"));
        System.out.print("rysq " + parameters.get("rysq"));
        if (output.getDimension() > 2L) {
            parameters.put("cz", z);
            parameters.put("rz", rz);
            parameters.put("rzsq", new Float(Math.pow(rz.floatValue(), 2.0)));
        }
        parameters.put("dst", output);
        parameters.put("value", value);
        clij2.execute(DrawSphere.class, "draw_sphere_" + output.getDimension() + "d_x.cl", "draw_sphere_" + output.getDimension() + "d", output.getDimensions(), output.getDimensions(), parameters);
        return true;
    }

    public static boolean drawSphere(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float rx, Float ry) {
        return DrawSphere.drawSphere(clij2, output, x, y, Float.valueOf(0.0f), rx, ry, Float.valueOf(0.0f), Float.valueOf(1.0f));
    }

    public static boolean drawSphere(CLIJ2 clij2, ClearCLImageInterface output, Float x, Float y, Float rx, Float ry, Float value) {
        return DrawSphere.drawSphere(clij2, output, x, y, Float.valueOf(0.0f), rx, ry, Float.valueOf(0.0f), value);
    }

    public String getDescription() {
        return "Draws a sphere around a given point with given radii in x, y and z (if 3D). \n\n All pixels other than in the sphere are untouched. Consider using `set(buffer, 0);` in advance.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Visualisation";
    }
}

