/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_entropyBox")
public class EntropyBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Measurements,Filter";
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number radiusX, number radiusY, Number radiusZ";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        int radiusX = EntropyBox.asInteger((Object)this.args[2]);
        int radiusY = EntropyBox.asInteger((Object)this.args[3]);
        int radiusZ = EntropyBox.asInteger((Object)this.args[4]);
        boolean result = this.getCLIJ2().entropyBox(input, output, radiusX, radiusY, radiusZ);
        return result;
    }

    public static boolean entropyBox(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer radiusX, Integer radiusY, Integer radiusZ) {
        float minIntensity = (float)clij2.minimumOfAllPixels((ClearCLImageInterface)src);
        float maxIntensity = (float)clij2.maximumOfAllPixels((ClearCLImageInterface)src);
        return EntropyBox.entropyBox(clij2, src, dst, radiusX, radiusY, radiusZ, Float.valueOf(minIntensity), Float.valueOf(maxIntensity));
    }

    public static boolean entropyBox(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer radiusX, Integer radiusY, Integer radiusZ, Float minIntensity, Float maxIntensity) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("radiusX", radiusX);
        parameters.put("radiusY", radiusY);
        if (src.getDimension() == 3L) {
            parameters.put("radiusZ", radiusZ);
        }
        parameters.put("minIntensity", minIntensity);
        parameters.put("maxIntensity", maxIntensity);
        clij2.execute(EntropyBox.class, "entropy_" + src.getDimension() + "d_x.cl", "entropy_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Determines the local entropy in a box with a given radius around every pixel.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getAuthorName() {
        return "Pit Kludig and Robert Haase";
    }
}

