/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_equal")
public class Equal
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        return this.getCLIJ2().equal((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]));
    }

    public static boolean equal(CLIJ2 clij2, ClearCLImageInterface src1, ClearCLImageInterface src2, ClearCLImageInterface dst) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.clear();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij2.execute(Equal.class, "equal_" + src1.getDimension() + "d_x.cl", "equal_" + src1.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source1, Image source2, ByRef Image destination";
    }

    public String getDescription() {
        return "Determines if two images A and B equal pixel wise.\n\n<pre>f(a, b) = 1 if a == b; 0 otherwise.</pre>\n\nParameters\n----------\nsource1 : Image\n    The first image to be compared with.\nsource2 : Image\n    The second image to be compared with the first.\ndestination : Image\n    The resulting binary image where pixels will be 1 only if source1 and source2 equal in the given pixel.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

