/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_equalizeMeanIntensitiesOfSlices")
public class EqualizeMeanIntensitiesOfSlices
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math,Filter";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0};
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number referenceSlice";
    }

    public boolean executeCL() {
        Object[] args = this.openCLBufferArgs();
        boolean result = this.getCLIJ2().equalizeMeanIntensitiesOfSlices((ClearCLBuffer)args[0], (ClearCLBuffer)args[1], EqualizeMeanIntensitiesOfSlices.asInteger((Object)args[2]).intValue());
        this.releaseBuffers(args);
        return result;
    }

    public static boolean equalizeMeanIntensitiesOfSlices(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Integer referenceSlice) {
        double[] intensities = clij2.sumImageSliceBySlice((ClearCLImageInterface)input);
        float[] factors = new float[intensities.length];
        for (int i = 0; i < factors.length; ++i) {
            factors[i] = (float)(intensities[referenceSlice] / intensities[i]);
        }
        clij2.multiplyImageStackWithScalars((ClearCLImageInterface)input, (ClearCLImageInterface)output, factors);
        return true;
    }

    public String getDescription() {
        return "Determines correction factors for each z-slice so that the average intensity in all slices can be made the same and multiplies these factors with the slices. \n\nThis functionality is similar to the 'Simple Ratio Bleaching Correction' in Fiji.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

