/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_excludeLabelsOnEdges")
public class ExcludeLabelsOnEdges
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public boolean executeCL() {
        ClearCLBuffer label_map_in = (ClearCLBuffer)this.args[0];
        ClearCLBuffer label_map_out = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().excludeLabelsOnEdges(label_map_in, label_map_out);
    }

    public static boolean excludeLabelsOnEdges(CLIJ2 clij2, ClearCLBuffer label_map_in, ClearCLBuffer label_map_out) {
        long[] dims;
        int max_label = (int)clij2.maximumOfAllPixels((ClearCLImageInterface)label_map_in);
        if (max_label == 0) {
            clij2.set((ClearCLImageInterface)label_map_out, 0.0);
            return true;
        }
        float[] label_indices = new float[max_label + 1];
        for (int i = 0; i < label_indices.length; ++i) {
            label_indices[i] = i;
        }
        ClearCLBuffer label_index_map = clij2.create(new long[]{label_indices.length, 1L, 1L}, clij2.Float);
        label_index_map.readFrom((Buffer)FloatBuffer.wrap(label_indices), true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", label_map_in);
        parameters.put("label_index_dst", label_index_map);
        if (label_map_in.getDimension() > 2L && label_map_in.getDepth() > 1L) {
            dims = new long[]{label_map_in.getWidth(), label_map_in.getHeight(), 1L};
            clij2.execute(ExcludeLabelsOnEdges.class, "excludeLabelsOnEdges_3d_x.cl", "exclude_on_edges_z_3d", dims, dims, parameters);
        }
        dims = new long[]{label_map_in.getWidth(), 1L, label_map_in.getDepth()};
        clij2.execute(ExcludeLabelsOnEdges.class, "excludeLabelsOnEdges_3d_x.cl", "exclude_on_edges_y_3d", dims, dims, parameters);
        dims = new long[]{1L, label_map_in.getHeight(), label_map_in.getDepth()};
        clij2.execute(ExcludeLabelsOnEdges.class, "excludeLabelsOnEdges_3d_x.cl", "exclude_on_edges_x_3d", dims, dims, parameters);
        label_index_map.writeTo((Buffer)FloatBuffer.wrap(label_indices), true);
        int count = 1;
        for (int i = 0; i < label_indices.length; ++i) {
            if (!(label_indices[i] > 0.0f)) continue;
            label_indices[i] = count;
            ++count;
        }
        label_index_map.readFrom((Buffer)FloatBuffer.wrap(label_indices), true);
        clij2.replaceIntensities((ClearCLImageInterface)label_map_in, (ClearCLImageInterface)label_index_map, (ClearCLImageInterface)label_map_out);
        return true;
    }

    public String getParameterHelpText() {
        return "Image label_map_input, ByRef Image label_map_destination";
    }

    public String getDescription() {
        return "Removes all labels from a label map which touch the edges of the image (in X, Y and Z if the image is 3D). \n\nRemaining label elements are renumbered afterwards.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getCategories() {
        return "Label, Filter";
    }
}

