/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_excludeLabelsSubSurface")
public class ExcludeLabelsSubSurface
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public boolean executeCL() {
        ClearCLBuffer pointlist = (ClearCLBuffer)this.args[0];
        ClearCLBuffer label_map_in = (ClearCLBuffer)this.args[1];
        ClearCLBuffer label_map_out = (ClearCLBuffer)this.args[2];
        float centerX = ExcludeLabelsSubSurface.asFloat((Object)this.args[3]).floatValue();
        float centerY = ExcludeLabelsSubSurface.asFloat((Object)this.args[4]).floatValue();
        float centerZ = ExcludeLabelsSubSurface.asFloat((Object)this.args[5]).floatValue();
        return this.getCLIJ2().excludeLabelsSubSurface(pointlist, label_map_in, label_map_out, centerX, centerY, centerZ);
    }

    public static boolean excludeLabelsSubSurface(CLIJ2 clij2, ClearCLBuffer pointlist, ClearCLBuffer label_map_in, ClearCLBuffer label_map_out, Float centerX, Float centerY, Float centerZ) {
        int max_label = (int)pointlist.getWidth();
        if (max_label == 0) {
            clij2.set((ClearCLImageInterface)label_map_out, 0.0);
            return true;
        }
        ClearCLBuffer label_index_map = clij2.create(new long[]{max_label, 1L, 1L}, clij2.Float);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_pointlist", pointlist);
        parameters.put("src_label_map", label_map_in);
        parameters.put("label_index_dst", label_index_map);
        parameters.put("centerX", centerX);
        parameters.put("centerY", centerY);
        if (label_map_in.getDimension() == 3L) {
            parameters.put("centerZ", centerZ);
        }
        long[] globalSizes = new long[]{pointlist.getWidth(), 1L, 1L};
        clij2.execute(ExcludeLabelsSubSurface.class, "exclude_labels_sub_surface_" + label_map_in.getDimension() + "d_x.cl", "exclude_labels_sub_surface_" + label_map_in.getDimension() + "d", label_index_map.getDimensions(), globalSizes, parameters);
        float[] label_indices = new float[(int)label_index_map.getWidth()];
        label_index_map.writeTo((Buffer)FloatBuffer.wrap(label_indices), true);
        int count = 1;
        for (int i = 0; i < label_indices.length; ++i) {
            if (!(label_indices[i] > 0.0f)) continue;
            label_indices[i] = count;
            ++count;
        }
        label_index_map.readFrom((Buffer)FloatBuffer.wrap(label_indices), true);
        clij2.replaceIntensities((ClearCLImageInterface)label_map_in, (ClearCLImageInterface)label_index_map, (ClearCLImageInterface)label_map_out);
        return true;
    }

    public String getParameterHelpText() {
        return "Image pointlist, Image label_map_input, ByRef Image label_map_destination, Number centerX, Number centerY, Number centerZ";
    }

    public String getDescription() {
        return "This operation follows a ray from a given position towards a label (or opposite direction) and checks if  there is another label between the label an the image border. \n\nIf yes, this label is eliminated from the label map.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getCategories() {
        return "Label, Filter";
    }
}

