/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_excludeLabelsWithValuesOutOfRange")
public class ExcludeLabelsWithValuesOutOfRange
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public boolean executeCL() {
        ClearCLBuffer values = (ClearCLBuffer)this.args[0];
        ClearCLBuffer label_map_in = (ClearCLBuffer)this.args[1];
        ClearCLBuffer label_map_out = (ClearCLBuffer)this.args[2];
        float min = ExcludeLabelsWithValuesOutOfRange.asFloat((Object)this.args[3]).floatValue();
        float max = ExcludeLabelsWithValuesOutOfRange.asFloat((Object)this.args[4]).floatValue();
        return this.getCLIJ2().excludeLabelsWithValuesOutOfRange(values, label_map_in, label_map_out, min, max);
    }

    public static boolean excludeLabelsWithValuesOutOfRange(CLIJ2 clij2, ClearCLBuffer values_in, ClearCLBuffer label_map_in, ClearCLBuffer label_map_out, Float min, Float max) {
        ClearCLBuffer values = values_in;
        if (values.getWidth() == label_map_in.getWidth() && values.getHeight() == label_map_in.getHeight() && values.getDepth() == label_map_in.getDepth()) {
            ResultsTable stats = new ResultsTable();
            clij2.statisticsOfBackgroundAndLabelledPixels(values_in, label_map_in, stats);
            values = clij2.create((long)clij2.getMaximumOfAllPixels((ClearCLImageInterface)label_map_in) + 1L, 1L, 1L);
            clij2.pushResultsTableColumn(values, stats, "MEAN_INTENSITY");
        }
        ClearCLBuffer below = clij2.create(values.getDimensions(), NativeTypeEnum.UnsignedByte);
        ClearCLBuffer above = clij2.create(values.getDimensions(), NativeTypeEnum.UnsignedByte);
        clij2.smallerConstant(values, below, min.floatValue());
        clij2.greaterConstant((ClearCLImageInterface)values, (ClearCLImageInterface)above, max.floatValue());
        ClearCLBuffer temp = clij2.create(values.getDimensions(), NativeTypeEnum.UnsignedByte);
        clij2.binaryOr((ClearCLImageInterface)below, (ClearCLImageInterface)above, (ClearCLImageInterface)temp);
        clij2.excludeLabels(temp, label_map_in, label_map_out);
        below.close();
        above.close();
        temp.close();
        if (values != values_in) {
            values.close();
        }
        return true;
    }

    public String getParameterHelpText() {
        return "Image values_vector, Image label_map_input, ByRef Image label_map_destination, Number minimum_value_range, Number maximum_value_range";
    }

    public String getDescription() {
        return "This operation removes labels from a labelmap and renumbers the remaining labels. \n\nHand over a vector of values and a range specifying which labels with which values are eliminated.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        ClearCLBuffer labelmap = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().create(labelmap);
    }

    public String getCategories() {
        return "Label, Filter, Measurements";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, null, 100, 1000};
    }
}

