/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_extendLabelingViaVoronoi")
public class ExtendLabelingViaVoronoi
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public boolean executeCL() {
        return ExtendLabelingViaVoronoi.extendLabelingViaVoronoi(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLImageInterface)((ClearCLBuffer)this.args[1]));
    }

    public static boolean extendLabelingViaVoronoi(CLIJ2 clij2, ClearCLBuffer src, ClearCLImageInterface dst) {
        ClearCLImage flip = clij2.create(dst.getDimensions(), ImageChannelDataType.Float);
        ClearCLImage flop = clij2.create(flip);
        ClearCLKernel flipKernel = null;
        ClearCLKernel flopKernel = null;
        clij2.copy((ClearCLImageInterface)src, (ClearCLImageInterface)flip);
        ClearCLBuffer flag = clij2.create(1L, 1L, 1L);
        float[] flagBool = new float[]{1.0f};
        FloatBuffer buffer = FloatBuffer.wrap(flagBool);
        int i = 0;
        while (flagBool[0] != 0.0f) {
            flagBool[0] = 0.0f;
            flag.readFrom((Buffer)buffer, true);
            if (i % 2 == 0) {
                flipKernel = clij2.onlyzeroOverwriteMaximumBox((ClearCLImageInterface)flip, (ClearCLImageInterface)flag, (ClearCLImageInterface)flop, flipKernel);
            } else {
                flopKernel = clij2.onlyzeroOverwriteMaximumDiamond((ClearCLImageInterface)flop, (ClearCLImageInterface)flag, (ClearCLImageInterface)flip, flopKernel);
            }
            ++i;
            flag.writeTo((Buffer)buffer, true);
        }
        if (i % 2 == 0) {
            clij2.copy((ClearCLImageInterface)flip, dst);
        } else {
            clij2.copy((ClearCLImageInterface)flop, dst);
        }
        if (flipKernel != null) {
            flipKernel.close();
        }
        if (flopKernel != null) {
            flopKernel.close();
        }
        clij2.release((ClearCLImageInterface)flip);
        clij2.release((ClearCLImageInterface)flop);
        clij2.release((ClearCLImageInterface)flag);
        return true;
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination";
    }

    public String getDescription() {
        return "Takes a label map image and dilates the regions using a octagon shape until they touch. \n\nThe resulting label map is written to the output.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Label, Filter";
    }
}

