/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_flip2D")
public class Flip2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        Boolean flipX = Flip2D.asBoolean((Object)this.args[2]);
        Boolean flipY = Flip2D.asBoolean((Object)this.args[3]);
        return this.getCLIJ2().flip((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), flipX, flipY);
    }

    public static boolean flip2D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Boolean flipx, Boolean flipy) {
        return Flip2D.flip(clij2, src, dst, flipx, flipy);
    }

    public static boolean flip(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Boolean flipx, Boolean flipy) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("flipx", flipx != false ? 1 : 0);
        parameters.put("flipy", flipy != false ? 1 : 0);
        clij2.execute(Flip2D.class, "flip_2d_x.cl", "flip_2d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Boolean flip_x, Boolean flip_y";
    }

    public String getDescription() {
        return "Flips an image in X and/or Y direction depending on if flip_x and/or flip_y are set to true or false.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

