/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_flip3D")
public class Flip3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        Boolean flipX = Flip3D.asBoolean((Object)this.args[2]);
        Boolean flipY = Flip3D.asBoolean((Object)this.args[3]);
        Boolean flipZ = Flip3D.asBoolean((Object)this.args[4]);
        return this.getCLIJ2().flip((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), flipX, flipY, flipZ);
    }

    public static boolean flip3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Boolean flipx, Boolean flipy, Boolean flipz) {
        return Flip3D.flip(clij2, src, dst, flipx, flipy, flipz);
    }

    public static boolean flip(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Boolean flipx, Boolean flipy, Boolean flipz) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("flipx", flipx != false ? 1 : 0);
        parameters.put("flipy", flipy != false ? 1 : 0);
        if (src.getDimension() > 2L) {
            parameters.put("flipz", flipz != false ? 1 : 0);
        }
        clij2.execute(Flip3D.class, "flip_" + src.getDimension() + "d_x.cl", "flip_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Boolean flip_x, Boolean flip_y, Boolean flip_z";
    }

    public String getDescription() {
        return "Flips an image in X, Y and/or Z direction depending on if flip_x, flip_y and/or flip_z are set to true or false.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

