/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_floodFillDiamond")
public class FloodFillDiamond
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0, 1};
    }

    public boolean executeCL() {
        return this.getCLIJ2().floodFillDiamond((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], FloodFillDiamond.asFloat((Object)this.args[2]).floatValue(), FloodFillDiamond.asFloat((Object)this.args[3]).floatValue());
    }

    public static boolean floodFillDiamond(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Float valueToReplace, Float valueReplacement) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), src.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (floodFillDiamond)");
        }
        ClearCLBuffer flag = clij2.create(1L, 1L, 1L);
        ClearCLBuffer temp = clij2.create(dst);
        float[] flag_arr = new float[1];
        FloatBuffer floatBuffer = FloatBuffer.wrap(flag_arr);
        ClearCLKernel kernel = null;
        clij2.copy((ClearCLImageInterface)src, (ClearCLImageInterface)temp);
        int dimension = 2;
        if (dst.getDimension() == 3L && dst.getDepth() > 1L) {
            dimension = 3;
        }
        boolean flipFlag = true;
        flag_arr[0] = 1.0f;
        while (flag_arr[0] == 1.0f) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (flipFlag) {
                parameters.put("src", temp);
                parameters.put("dst", dst);
            } else {
                parameters.put("src", dst);
                parameters.put("dst", temp);
            }
            flipFlag = !flipFlag;
            flag_arr[0] = 0.0f;
            flag.readFrom((Buffer)floatBuffer, true);
            parameters.put("flag_dst", flag);
            parameters.put("value_to_replace", valueToReplace);
            parameters.put("value_replacement", valueReplacement);
            parameters.put("dimension", dimension);
            kernel = clij2.executeSubsequently(FloodFillDiamond.class, "flood_fill_diamond_x.cl", "flood_fill_diamond", dst.getDimensions(), dst.getDimensions(), parameters, kernel);
            flag.writeTo((Buffer)floatBuffer, true);
        }
        if (flipFlag) {
            clij2.copy((ClearCLImageInterface)temp, (ClearCLImageInterface)dst);
        }
        clij2.release((ClearCLImageInterface)temp);
        clij2.release((ClearCLImageInterface)flag);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number value_to_replace, Number value_replacement";
    }

    public String getDescription() {
        return "Replaces recursively all pixels of value a with value b if the pixels have a neighbor with value b.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Filter";
    }
}

