/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_GPUProperties")
public class GPUProperties
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("GPUName", this.clij.getGPUName());
        table.addValue("Global_memory_in_bytes", (double)this.clij.getGPUMemoryInBytes());
        table.addValue("OpenCL_version", this.clij.getOpenCLVersion());
        table.show("Results");
        return true;
    }

    public String getParameterHelpText() {
        return "";
    }

    public String getDescription() {
        return "Reads out properties of the currently active GPU writes it to the \n results table in the columns 'GPUName', 'Global_memory_in_bytes' and 'OpenCL_Version'.";
    }

    public String getAvailableForDimensions() {
        return "";
    }
}

