/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.GaussianBlur3D;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_gaussianBlur2D")
public class GaussianBlur2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 2};
    }

    public boolean executeCL() {
        float sigmaX = GaussianBlur2D.asFloat((Object)this.args[2]).floatValue();
        float sigmaY = GaussianBlur2D.asFloat((Object)this.args[3]).floatValue();
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        CLIJ2 clij2 = this.getCLIJ2();
        if (clij2.hasImageSupport()) {
            ClearCLImage image = clij2.create(input.getDimensions(), CLIJUtilities.nativeToChannelType(input.getNativeType()));
            clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)image);
            clij2.gaussianBlur2D((ClearCLImageInterface)image, (ClearCLImageInterface)output, sigmaX, sigmaY);
            clij2.release((ClearCLImageInterface)image);
        } else {
            clij2.gaussianBlur2D((ClearCLImageInterface)input, (ClearCLImageInterface)output, sigmaX, sigmaY);
        }
        return true;
    }

    @Deprecated
    public static boolean blur2D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY) {
        return GaussianBlur2D.gaussianBlur(clij2, src, dst, blurSigmaX, blurSigmaY);
    }

    @Deprecated
    public static boolean blur(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY) {
        return GaussianBlur2D.gaussianBlur(clij2, src, dst, blurSigmaX, blurSigmaY);
    }

    public static boolean gaussianBlur2D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY) {
        return GaussianBlur2D.gaussianBlur(clij2, src, dst, blurSigmaX, blurSigmaY);
    }

    public static boolean gaussianBlur(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY) {
        return GaussianBlur3D.blur(clij2, src, dst, blurSigmaX, blurSigmaY, Float.valueOf(0.0f));
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number sigma_x, Number sigma_y";
    }

    public String getDescription() {
        return "Computes the Gaussian blurred image of an image given two sigma values in X and Y. \n\nThus, the filterkernel can have non-isotropic shape.\n\nThe implementation is done separable. In case a sigma equals zero, the direction is not blurred.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }

    public String getCategories() {
        return "Filter, Noise";
    }
}

