/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clij2.utilities.ProcessableInTiles;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_gaussianBlur3D")
public class GaussianBlur3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
ProcessableInTiles,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 2, 2};
    }

    public boolean executeCL() {
        float sigmaX = GaussianBlur3D.asFloat((Object)this.args[2]).floatValue();
        float sigmaY = GaussianBlur3D.asFloat((Object)this.args[3]).floatValue();
        float sigmaZ = GaussianBlur3D.asFloat((Object)this.args[4]).floatValue();
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        CLIJ2 clij2 = this.getCLIJ2();
        if (clij2.hasImageSupport()) {
            ClearCLImage image = clij2.create(input.getDimensions(), CLIJUtilities.nativeToChannelType(input.getNativeType()));
            clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)image);
            clij2.gaussianBlur3D((ClearCLImageInterface)image, (ClearCLImageInterface)output, sigmaX, sigmaY, sigmaZ);
            clij2.release((ClearCLImageInterface)image);
        } else {
            clij2.gaussianBlur3D((ClearCLImageInterface)input, (ClearCLImageInterface)output, sigmaX, sigmaY, sigmaZ);
        }
        return true;
    }

    @Deprecated
    public static boolean blur3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY, Float blurSigmaZ) {
        return GaussianBlur3D.gaussianBlur3D(clij2, src, dst, blurSigmaX, blurSigmaY, blurSigmaZ);
    }

    @Deprecated
    public static boolean blur(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY, Float blurSigmaZ) {
        return GaussianBlur3D.gaussianBlur(clij2, src, dst, blurSigmaX, blurSigmaY, blurSigmaZ);
    }

    public static boolean gaussianBlur3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY, Float blurSigmaZ) {
        return GaussianBlur3D.gaussianBlur(clij2, src, dst, blurSigmaX, blurSigmaY, blurSigmaZ);
    }

    public static boolean gaussianBlur(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Float blurSigmaX, Float blurSigmaY, Float blurSigmaZ) {
        return CLIJUtilities.executeSeparableKernel(clij2, src, dst, GaussianBlur3D.class, "gaussian_blur_separable_" + src.getDimension() + "d_x.cl", "gaussian_blur_separable_" + src.getDimension() + "d", net.haesleinhuepf.clij.utilities.CLIJUtilities.sigmaToKernelSize((float)blurSigmaX.floatValue()), net.haesleinhuepf.clij.utilities.CLIJUtilities.sigmaToKernelSize((float)blurSigmaY.floatValue()), net.haesleinhuepf.clij.utilities.CLIJUtilities.sigmaToKernelSize((float)blurSigmaZ.floatValue()), blurSigmaX.floatValue(), blurSigmaY.floatValue(), blurSigmaZ.floatValue(), src.getDimension());
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number sigma_x, Number sigma_y, Number sigma_z";
    }

    public String getDescription() {
        return "Computes the Gaussian blurred image of an image given two sigma values in X, Y and Z. \n\nThus, the filterkernel can have non-isotropic shape.\n\nThe implementation is done separable. In case a sigma equals zero, the direction is not blurred.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getCategories() {
        return "Filter, Noise";
    }
}

