/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_generateDistanceMatrix")
public class GenerateDistanceMatrix
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Vector";
    }

    @Override
    public String getOutputType() {
        return "Matrix";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().generateDistanceMatrix((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean generateDistanceMatrix(CLIJ2 clij2, ClearCLBuffer src_pointlist1, ClearCLBuffer src_pointlist2, ClearCLBuffer dst_distance_matrix) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_point_list1", src_pointlist1);
        parameters.put("src_point_list2", src_pointlist2);
        parameters.put("dst_matrix", dst_distance_matrix);
        long[] globalSizes = new long[]{src_pointlist1.getWidth(), 1L, 1L};
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(GenerateDistanceMatrix.class, "generate_distance_matrix_x.cl", "generate_distance_matrix", globalSizes, globalSizes, parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image coordinate_list1, Image coordinate_list2, ByRef Image distance_matrix_destination";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        ClearCLBuffer input1 = (ClearCLBuffer)this.args[0];
        ClearCLBuffer input2 = (ClearCLBuffer)this.args[1];
        return this.clij.createCLBuffer(new long[]{input1.getWidth() + 1L, input2.getWidth() + 1L}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Computes the distance between all point coordinates given in two point lists.\n\nTakes two images containing pointlists (dimensionality n * d, n: number of points and d: dimensionality) and builds up a matrix containing the distances between these points. \n\nConvention: Given two point lists with dimensionality n * d and m * d, the distance matrix will be of size(n + 1) * (m + 1). The first row and column contain zeros. They represent the distance of the objects to a theoretical background object. In that way, distance matrices are of the same size as touch matrices (see generateTouchMatrix). Thus, one can threshold a distance matrix to generate a touch matrix out of it for drawing meshes.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }

    public String getCategories() {
        return "Measurement, Graph";
    }
}

