/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_generateJaccardIndexMatrix")
public class GenerateJaccardIndexMatrix
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Matrix";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().generateJaccardIndexMatrix((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean generateJaccardIndexMatrix(CLIJ2 clij2, ClearCLBuffer src_label_map1, ClearCLBuffer src_label_map2, ClearCLBuffer dst_jaccard_index_matrix) {
        int i;
        int num_threads = (int)src_label_map1.getDepth();
        long[][][] counts = new long[num_threads][(int)dst_jaccard_index_matrix.getWidth()][(int)dst_jaccard_index_matrix.getHeight()];
        Thread[] threads = new Thread[num_threads];
        Statistician[] statisticians = new Statistician[num_threads];
        for (i = 0; i < num_threads; ++i) {
            statisticians[i] = new Statistician(counts[i], clij2, src_label_map1, src_label_map2, i);
            threads[i] = new Thread(statisticians[i]);
            threads[i].start();
        }
        for (i = 0; i < num_threads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        float[][] matrix = new float[(int)dst_jaccard_index_matrix.getWidth()][(int)dst_jaccard_index_matrix.getHeight()];
        for (int t = 0; t < num_threads; ++t) {
            for (int j = 0; j < counts[0].length; ++j) {
                for (int k = 0; k < counts[0][0].length; ++k) {
                    float[] fArray = matrix[j];
                    int n = k;
                    fArray[n] = fArray[n] + (float)counts[t][j][k];
                }
            }
        }
        ClearCLBuffer true_positives = clij2.pushMatXYZ(matrix);
        ClearCLBuffer false_negatives = clij2.create(true_positives.getWidth(), 1L);
        ClearCLBuffer false_positives = clij2.create(1L, true_positives.getHeight());
        clij2.sumYProjection((ClearCLImageInterface)true_positives, (ClearCLImageInterface)false_negatives);
        clij2.sumXProjection((ClearCLImageInterface)true_positives, (ClearCLImageInterface)false_positives);
        ClearCLBuffer temp1 = clij2.create(true_positives);
        ClearCLBuffer temp2 = clij2.create(true_positives);
        clij2.addImagesWeighted((ClearCLImageInterface)true_positives, (ClearCLImageInterface)false_negatives, (ClearCLImageInterface)temp1, -1.0, 1.0);
        clij2.addImages((ClearCLImageInterface)temp1, (ClearCLImageInterface)false_positives, (ClearCLImageInterface)temp2);
        clij2.divideImages((ClearCLImageInterface)true_positives, (ClearCLImageInterface)temp2, (ClearCLImageInterface)dst_jaccard_index_matrix);
        true_positives.close();
        false_negatives.close();
        false_positives.close();
        temp1.close();
        temp2.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image label_map1, Image label_map2, ByRef Image jaccard_index_matrix_destination";
    }

    public String getCategories() {
        return "Measurement, Graph";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        double maxValue1 = this.clij.op().maximumOfAllPixels((ClearCLBuffer)this.args[0]) + 1.0;
        double maxValue2 = this.clij.op().maximumOfAllPixels((ClearCLBuffer)this.args[1]) + 1.0;
        ClearCLBuffer output = this.clij.createCLBuffer(new long[]{(long)maxValue1, (long)maxValue2}, NativeTypeEnum.Float);
        return output;
    }

    public String getDescription() {
        return "Takes two labelmaps with n and m labels_2 and generates a (n+1)*(m+1) matrix where all labels_1 are set to 0 exept those where labels_2 overlap between the label maps. \n\nFor the remaining labels_1, the value will be between 0 and 1 indicating the overlap as measured by the Jaccard Index.\nMajor parts of this operation run on the CPU.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    private static class Statistician
    implements Runnable {
        private ClearCLBuffer input_label_map_1;
        private ClearCLBuffer input_label_map_2;
        private final int zPlane;
        private final CLIJ2 clij2;
        long[][] tps;
        private float[] labels_1;
        private float[] labels_2;

        Statistician(long[][] tps, CLIJ2 clij2, ClearCLBuffer input_label_map_1, ClearCLBuffer input_label_map_2, int zPlane) {
            this.tps = tps;
            this.input_label_map_1 = input_label_map_1;
            this.input_label_map_2 = input_label_map_2;
            this.zPlane = zPlane;
            this.clij2 = clij2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CLIJ2 cLIJ2 = this.clij2;
            synchronized (cLIJ2) {
                ClearCLBuffer label_map_1_slice = this.clij2.create(this.input_label_map_1.getWidth(), this.input_label_map_1.getHeight());
                this.clij2.copySlice((ClearCLImageInterface)this.input_label_map_1, (ClearCLImageInterface)label_map_1_slice, this.zPlane);
                this.labels_1 = new float[(int)(label_map_1_slice.getWidth() * label_map_1_slice.getHeight())];
                label_map_1_slice.writeTo((Buffer)FloatBuffer.wrap(this.labels_1), true);
                label_map_1_slice.close();
                ClearCLBuffer label_map_2_slice = this.clij2.create(this.input_label_map_2.getWidth(), this.input_label_map_2.getHeight());
                this.clij2.copySlice((ClearCLImageInterface)this.input_label_map_2, (ClearCLImageInterface)label_map_2_slice, this.zPlane);
                this.labels_2 = new float[(int)(label_map_2_slice.getWidth() * label_map_2_slice.getHeight())];
                label_map_2_slice.writeTo((Buffer)FloatBuffer.wrap(this.labels_2), true);
                label_map_2_slice.close();
            }
            int width = (int)this.input_label_map_1.getWidth();
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.labels_1.length; ++i) {
                int label_1 = (int)this.labels_1[i];
                int label_2 = (int)this.labels_2[i];
                long[] lArray = this.tps[label_1];
                int n = label_2;
                lArray[n] = lArray[n] + 1L;
                if (++x < width) continue;
                x = 0;
                ++y;
            }
        }
    }
}

