/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_generateTouchCountMatrix")
public class GenerateTouchCountMatrix
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Matrix";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().generateTouchCountMatrix((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
        return result;
    }

    public static boolean generateTouchCountMatrix(CLIJ2 clij2, ClearCLBuffer src_label_map1, ClearCLBuffer dst_touch_count_matrix) {
        int i;
        int num_threads = (int)src_label_map1.getDepth();
        long[][][] counts = new long[num_threads][(int)dst_touch_count_matrix.getWidth()][(int)dst_touch_count_matrix.getHeight()];
        Thread[] threads = new Thread[num_threads];
        Statistician[] statisticians = new Statistician[num_threads];
        ArrayList<float[]> buffers = new ArrayList<float[]>();
        ClearCLBuffer label_map_slice = clij2.create(src_label_map1.getWidth(), src_label_map1.getHeight());
        for (i = 0; i < num_threads; ++i) {
            float[] labels_2;
            float[] labels_1;
            if (i == 0) {
                clij2.copySlice((ClearCLImageInterface)src_label_map1, (ClearCLImageInterface)label_map_slice, i);
                labels_1 = new float[(int)(label_map_slice.getWidth() * label_map_slice.getHeight())];
                label_map_slice.writeTo((Buffer)FloatBuffer.wrap(labels_1), true);
                buffers.add(labels_1);
            } else {
                labels_1 = (float[])buffers.get(i);
            }
            if (i < num_threads - 1) {
                clij2.copySlice((ClearCLImageInterface)src_label_map1, (ClearCLImageInterface)label_map_slice, i + 1);
                labels_2 = new float[(int)(label_map_slice.getWidth() * label_map_slice.getHeight())];
                label_map_slice.writeTo((Buffer)FloatBuffer.wrap(labels_2), true);
                buffers.add(labels_2);
            } else {
                labels_2 = null;
            }
            statisticians[i] = new Statistician(counts[i], clij2, labels_1, labels_2, (int)src_label_map1.getWidth(), (int)src_label_map1.getHeight(), i);
            threads[i] = new Thread(statisticians[i]);
            threads[i].start();
        }
        label_map_slice.close();
        for (i = 0; i < num_threads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        buffers.clear();
        float[][] matrix = new float[(int)dst_touch_count_matrix.getWidth()][(int)dst_touch_count_matrix.getHeight()];
        for (int t = 0; t < num_threads; ++t) {
            for (int j = 0; j < counts[0].length; ++j) {
                for (int k = 0; k < counts[0][0].length; ++k) {
                    float[] fArray = matrix[j];
                    int n = k;
                    fArray[n] = fArray[n] + (float)counts[t][j][k];
                }
            }
        }
        ClearCLBuffer countMatrix = clij2.pushMat(matrix);
        clij2.copy((ClearCLImageInterface)countMatrix, (ClearCLImageInterface)dst_touch_count_matrix);
        countMatrix.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image label_map, ByRef Image touch_count_matrix_destination";
    }

    public String getCategories() {
        return "Label, Measurement, Graph";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        double maxValue = this.clij.op().maximumOfAllPixels((ClearCLBuffer)this.args[0]) + 1.0;
        ClearCLBuffer output = this.clij.createCLBuffer(new long[]{(long)maxValue, (long)maxValue}, NativeTypeEnum.Float);
        return output;
    }

    public String getDescription() {
        return "Takes a label map with n labels and generates a (n+1)*(n+1) matrix where all pixels are set the number of pixels where labels touch (diamond neighborhood). \n\nMajor parts of this operation run on the CPU.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    private static class Statistician
    implements Runnable {
        private final int width;
        private final int height;
        private final int zPlane;
        private final CLIJ2 clij2;
        long[][] tps;
        private float[] labels_1;
        private float[] labels_2;

        Statistician(long[][] tps, CLIJ2 clij2, float[] labels_1, float[] labels_2, int width, int height, int zPlane) {
            this.tps = tps;
            this.labels_1 = labels_1;
            this.labels_2 = labels_2;
            this.width = width;
            this.height = height;
            this.zPlane = zPlane;
            this.clij2 = clij2;
        }

        @Override
        public void run() {
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.labels_1.length; ++i) {
                int label_2;
                int label_1;
                if (x < this.width - 1) {
                    label_1 = (int)this.labels_1[i];
                    label_2 = (int)this.labels_1[i + 1];
                    if (label_1 > label_2) {
                        long[] lArray = this.tps[label_1];
                        int n = label_2;
                        lArray[n] = lArray[n] + 1L;
                    } else if (label_1 < label_2) {
                        long[] lArray = this.tps[label_2];
                        int n = label_1;
                        lArray[n] = lArray[n] + 1L;
                    }
                }
                if (y < this.height - 1) {
                    label_1 = (int)this.labels_1[i];
                    label_2 = (int)this.labels_1[i + this.width];
                    if (label_1 > label_2) {
                        long[] lArray = this.tps[label_1];
                        int n = label_2;
                        lArray[n] = lArray[n] + 1L;
                    } else if (label_1 < label_2) {
                        long[] lArray = this.tps[label_2];
                        int n = label_1;
                        lArray[n] = lArray[n] + 1L;
                    }
                }
                if (this.labels_2 != null) {
                    label_1 = (int)this.labels_1[i];
                    label_2 = (int)this.labels_2[i];
                    if (label_1 > label_2) {
                        long[] lArray = this.tps[label_1];
                        int n = label_2;
                        lArray[n] = lArray[n] + 1L;
                    } else if (label_1 < label_2) {
                        long[] lArray = this.tps[label_2];
                        int n = label_1;
                        lArray[n] = lArray[n] + 1L;
                    }
                }
                if (++x < this.width) continue;
                x = 0;
                ++y;
            }
        }
    }
}

