/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import java.util.Arrays;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.AutoThresholderImageJ1;
import net.haesleinhuepf.clij2.plugins.Histogram;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasLicense;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_getAutomaticThreshold")
public class GetAutomaticThreshold
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor,
HasLicense,
IsCategorized {
    public boolean executeCL() {
        ClearCLBuffer src = (ClearCLBuffer)this.args[0];
        String userSelectedMethod = (String)this.args[1];
        double threshold = this.getCLIJ2().getAutomaticThreshold(src, userSelectedMethod);
        ((Double[])this.args[2])[0] = threshold;
        return true;
    }

    public static double getAutomaticThreshold(CLIJ2 clij2, ClearCLBuffer src, String userSelectedMethod) {
        Float minimumGreyValue = Float.valueOf(0.0f);
        Float maximumGreyValue = Float.valueOf(0.0f);
        Integer numberOfBins = 256;
        if (src.getNativeType() == NativeTypeEnum.UnsignedByte) {
            minimumGreyValue = Float.valueOf(0.0f);
            maximumGreyValue = Float.valueOf(255.0f);
        } else {
            minimumGreyValue = null;
            maximumGreyValue = null;
        }
        return GetAutomaticThreshold.getAutomaticThreshold(clij2, src, userSelectedMethod, minimumGreyValue, maximumGreyValue, 256);
    }

    public static double getAutomaticThreshold(CLIJ2 clij2, ClearCLBuffer src, String userSelectedMethod, Float minimumGreyValue, Float maximumGreyValue, Integer numberOfBins) {
        if (minimumGreyValue == null) {
            minimumGreyValue = Float.valueOf(new Double(clij2.minimumOfAllPixels((ClearCLImageInterface)src)).floatValue());
        }
        if (maximumGreyValue == null) {
            maximumGreyValue = Float.valueOf(new Double(clij2.maximumOfAllPixels((ClearCLImageInterface)src)).floatValue());
        }
        ClearCLBuffer histogram = clij2.create(new long[]{numberOfBins.intValue(), 1L, 1L}, clij2.Float);
        Histogram.fillHistogram(clij2, src, histogram, minimumGreyValue, maximumGreyValue);
        ImagePlus histogramImp = clij2.convert(histogram, ImagePlus.class);
        clij2.release((ClearCLImageInterface)histogram);
        float[] determinedHistogram = (float[])histogramImp.getProcessor().getPixels();
        int[] convertedHistogram = new int[determinedHistogram.length];
        long sum = 0L;
        for (int i = 0; i < determinedHistogram.length; ++i) {
            convertedHistogram[i] = (int)determinedHistogram[i];
            sum += (long)convertedHistogram[i];
        }
        String method = "Default";
        for (String choice : AutoThresholderImageJ1.getMethods()) {
            if (choice.toLowerCase().compareTo(userSelectedMethod.toLowerCase()) != 0) continue;
            method = choice;
        }
        float threshold = new AutoThresholderImageJ1().getThreshold(method, convertedHistogram);
        threshold = minimumGreyValue.floatValue() + (threshold + 1.0f) / 255.0f * (maximumGreyValue.floatValue() - minimumGreyValue.floatValue());
        return threshold;
    }

    public String getDescription() {
        StringBuilder doc = new StringBuilder();
        doc.append("Determines a threshold according to a given method and saves it to the threshold_value variable.\n\nThe automatic thresholder utilizes the threshold methods from ImageJ on a histogram determined on \nthe GPU to determine a threshold value as similar as possible to ImageJ 'Apply Threshold' method. \n\nEnter one \nof these methods in the method text field:\n" + Arrays.toString(AutoThresholderImageJ1.getMethods()));
        return doc.toString();
    }

    public String getParameterHelpText() {
        return "Image input, String method, ByRef Number threshold_value";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getAuthorName() {
        return "Robert Haase based on work by G. Landini and W. Rasband";
    }

    public String getLicense() {
        return "The code for the automatic thresholding methods originates from https://github.com/imagej/imagej1/blob/master/ij/process/AutoThresholder.java\n\nDetailed documentation on the implemented methods can be found online: https://imagej.net/Auto_Threshold";
    }

    public String getCategories() {
        return "Binary, Measurements";
    }
}

