/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_getDimensions")
public class GetDimensions
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        ClearCLBuffer buffer = (ClearCLBuffer)this.args[0];
        long[] dimensions = this.getCLIJ2().getDimensions(buffer);
        ((Double[])this.args[1])[0] = dimensions[0];
        ((Double[])this.args[2])[0] = dimensions[1];
        ((Double[])this.args[3])[0] = buffer.getDimension() > 2L ? Double.valueOf(dimensions[2]) : Double.valueOf(1.0);
        return true;
    }

    public static long[] getDimensions(CLIJ2 clij2, ClearCLBuffer buffer) {
        if (buffer.getDimension() == 3L) {
            return new long[]{buffer.getWidth(), buffer.getHeight(), buffer.getDepth()};
        }
        return new long[]{buffer.getWidth(), buffer.getHeight()};
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Number width, ByRef Number height, ByRef Number depth";
    }

    public String getDescription() {
        return "Reads out the size of an image [stack] and writes it to the variables 'width', 'height' and 'depth'.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

