/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_greaterConstant")
public class GreaterConstant
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getCategories() {
        return "Math";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0};
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().greaterConstant((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), GreaterConstant.asFloat((Object)this.args[2]).floatValue());
        return result;
    }

    public static boolean greaterConstant(CLIJ2 clij2, ClearCLImageInterface src1, ClearCLImageInterface dst, Float scalar) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.clear();
        parameters.put("src1", src1);
        parameters.put("scalar", scalar);
        parameters.put("dst", dst);
        clij2.execute(GreaterConstant.class, "greater_constant_" + src1.getDimension() + "d_x.cl", "greater_constant_" + src1.getDimension() + "d", src1.getDimensions(), src1.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number constant";
    }

    public String getDescription() {
        return "Determines if two images A and B greater pixel wise. \n\nf(a, b) = 1 if a > b; 0 otherwise. ";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

