/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import ij.measure.ResultsTable;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.HasLicense;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_histogram")
public class Histogram
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasLicense,
HasAuthor,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Vector";
    }

    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        ClearCLBuffer src = (ClearCLBuffer)this.args[0];
        ClearCLBuffer histogram = (ClearCLBuffer)this.args[1];
        Integer numberOfBins = Histogram.asInteger((Object)this.args[2]);
        Float minimumGreyValue = Histogram.asFloat((Object)this.args[3]);
        Float maximumGreyValue = Histogram.asFloat((Object)this.args[4]);
        Boolean determineMinMax = Histogram.asBoolean((Object)this.args[5]);
        return this.getCLIJ2().histogram(src, histogram, numberOfBins.intValue(), minimumGreyValue.floatValue(), maximumGreyValue.floatValue(), determineMinMax, false);
    }

    public static float[] histogram(CLIJ2 clij2, ClearCLBuffer image, Float minGreyValue, Float maxGreyValue, Integer numberOfBins) {
        ClearCLBuffer histogram = clij2.create(new long[]{numberOfBins.intValue(), 1L, 1L}, NativeTypeEnum.Float);
        if (minGreyValue == null) {
            minGreyValue = Float.valueOf(new Double(clij2.minimumOfAllPixels((ClearCLImageInterface)image)).floatValue());
        }
        if (maxGreyValue == null) {
            maxGreyValue = Float.valueOf(new Double(clij2.maximumOfAllPixels((ClearCLImageInterface)image)).floatValue());
        }
        Histogram.fillHistogram(clij2, image, histogram, minGreyValue, maxGreyValue);
        ImagePlus histogramImp = clij2.convert(histogram, ImagePlus.class);
        histogram.close();
        float[] determinedHistogram = (float[])histogramImp.getProcessor().getPixels();
        return determinedHistogram;
    }

    public static boolean histogram(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer histogram) {
        return Histogram.histogram(clij2, src, histogram, 256, Float.valueOf(0.0f), Float.valueOf(0.0f), true);
    }

    public static ClearCLBuffer histogram(CLIJ2 clij2, ClearCLBuffer src) {
        ClearCLBuffer histogram = clij2.create(new long[]{256L, 1L, 1L}, clij2.Float);
        Histogram.histogram(clij2, src, histogram, (int)histogram.getWidth(), Float.valueOf(0.0f), Float.valueOf(0.0f), true);
        return histogram;
    }

    public static boolean histogram(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer histogram, Integer numberOfBins, Float minimumGreyValue, Float maximumGreyValue, Boolean determineMinMax) {
        return Histogram.histogram(clij2, src, histogram, numberOfBins, minimumGreyValue, maximumGreyValue, determineMinMax, false);
    }

    public static boolean histogram(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer histogram, Integer numberOfBins, Float minimumGreyValue, Float maximumGreyValue, Boolean determineMinMax, boolean showTable) {
        if (determineMinMax.booleanValue()) {
            minimumGreyValue = Float.valueOf(new Double(clij2.minimumOfAllPixels((ClearCLImageInterface)src)).floatValue());
            maximumGreyValue = Float.valueOf(new Double(clij2.maximumOfAllPixels((ClearCLImageInterface)src)).floatValue());
        }
        boolean result = Histogram.fillHistogram(clij2, src, histogram, minimumGreyValue, maximumGreyValue);
        ImagePlus histogramImp = clij2.convert(histogram, ImagePlus.class);
        float[] determinedHistogram = (float[])histogramImp.getProcessor().getPixels();
        float[] xAxis = new float[numberOfBins.intValue()];
        xAxis[0] = minimumGreyValue.floatValue();
        float step = (maximumGreyValue.floatValue() - minimumGreyValue.floatValue()) / (float)(numberOfBins - 1);
        for (int i = 1; i < xAxis.length; ++i) {
            xAxis[i] = xAxis[i - 1] + step;
        }
        if (showTable) {
            ResultsTable table = ResultsTable.getResultsTable();
            for (int i = 0; i < xAxis.length; ++i) {
                table.incrementCounter();
                table.addValue("Grey value", (double)xAxis[i]);
                table.addValue("Number of pixels", (double)determinedHistogram[i]);
            }
            table.show(table.getTitle());
        }
        return result;
    }

    @Deprecated
    public static boolean fillHistogram(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dstHistogram, Float minimumGreyValue, Float maximumGreyValue) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dstHistogram);
        int stepSizeX = 1;
        int stepSizeY = 1;
        int stepSizeZ = 1;
        long[] globalSizes = new long[]{src.getHeight() / (long)stepSizeZ, 1L, 1L};
        long numberOfPartialHistograms = globalSizes[0] * globalSizes[1] * globalSizes[2];
        long[] histogramBufferSize = new long[]{dstHistogram.getWidth(), 1L, numberOfPartialHistograms};
        long timeStamp = System.currentTimeMillis();
        ClearCLBuffer partialHistograms = clij2.create(histogramBufferSize, dstHistogram.getNativeType());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst_histogram", partialHistograms);
        parameters.put("minimum", minimumGreyValue);
        parameters.put("maximum", maximumGreyValue);
        parameters.put("step_size_x", stepSizeX);
        parameters.put("step_size_y", stepSizeY);
        if (src.getDimension() > 2L) {
            parameters.put("step_size_z", stepSizeZ);
        }
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("NUMBER_OF_HISTOGRAM_BINS", dstHistogram.getWidth());
        clij2.execute(Histogram.class, "histogram_" + src.getDimension() + "d_x.cl", "histogram_" + src.getDimension() + "d", dstHistogram.getDimensions(), globalSizes, parameters, constants);
        clij2.sumZProjection((ClearCLImageInterface)partialHistograms, (ClearCLImageInterface)dstHistogram);
        partialHistograms.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number number_of_bins, Number minimum_intensity, Number maximum_intensity, Boolean determine_min_max";
    }

    public String getDescription() {
        return "Determines the histogram of a given image.\n\nThe histogram image is of dimensions number_of_bins/1/1; a 3D image with height=1 and depth=1. \nHistogram bins contain the number of pixels with intensity in this corresponding bin. \nThe histogram bins are uniformly distributed between given minimum and maximum grey value intensity. \nIf the flag determine_min_max is set, minimum and maximum intensity will be determined. \nWhen calling this operation many times, it is recommended to determine minimum and maximum intensity \nonce at the beginning and handing over these values.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        Integer numberOfBins = Histogram.asInteger((Object)this.args[2]);
        return this.clij.createCLBuffer(new long[]{numberOfBins.intValue(), 1L, 1L}, NativeTypeEnum.Float);
    }

    public String getAuthorName() {
        return "Robert Haase adapted work from Aaftab Munshi, Benedict Gaster, Timothy Mattson, James Fung, Dan Ginsburg";
    }

    public String getLicense() {
        return "// adapted code from\n// https://github.com/bgaster/opencl-book-samples/blob/master/src/Chapter_14/histogram/histogram_image.cl\n//\n// It was published unter BSD license according to\n// https://code.google.com/archive/p/opencl-book-samples/\n//\n// Book:      OpenCL(R) Programming Guide\n// Authors:   Aaftab Munshi, Benedict Gaster, Timothy Mattson, James Fung, Dan Ginsburg\n// ISBN-10:   0-321-74964-2\n// ISBN-13:   978-0-321-74964-2\n// Publisher: Addison-Wesley Professional\n// URLs:      http://safari.informit.com/9780132488006/\n//            http://www.openclprogrammingguide.com";
    }
}

