/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_imageToStack")
public class ImageToStack
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 100};
    }

    public boolean executeCL() {
        return this.getCLIJ2().imageToStack((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], ImageToStack.asInteger((Object)this.args[2]).intValue());
    }

    public static boolean imageToStack(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer numSlices) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        ClearCLBuffer buffer = src;
        if (src.getDimension() == 3L) {
            buffer = clij2.create(new long[]{src.getWidth(), src.getHeight()}, src.getNativeType());
            clij2.copySlice((ClearCLImageInterface)src, (ClearCLImageInterface)buffer, 0.0);
        }
        for (int i = 0; i < numSlices; ++i) {
            clij2.copySlice((ClearCLImageInterface)buffer, (ClearCLImageInterface)dst, i);
        }
        if (buffer != src) {
            clij2.release((ClearCLImageInterface)buffer);
        }
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int num_slices = ImageToStack.asInteger((Object)this.args[2]);
        return this.getCLIJ2().create(new long[]{input.getWidth(), input.getHeight(), num_slices}, input.getNativeType());
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number num_slices";
    }

    public String getDescription() {
        return "Copies a single slice into a stack a given number of times.";
    }

    public String getAvailableForDimensions() {
        return "2D -> 3D";
    }
}

