/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.StatisticsOfLabelledPixels;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_spotsToPointList")
public class LabelCentroidsToPointList
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Pointlist";
    }

    public String getParameterHelpText() {
        return "Image input_spots, ByRef Image destination_pointlist";
    }

    public boolean executeCL() {
        return LabelCentroidsToPointList.labelCentroidsToPointList(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
    }

    public static boolean labelCentroidsToPointList(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output) {
        double[][] stats = clij2.statisticsOfLabelledPixels(input, input);
        ClearCLBuffer table = clij2.pushMatXYZ(stats);
        ClearCLBuffer cl_pos = clij2.create(table.getWidth(), 1L);
        clij2.crop((ClearCLImageInterface)table, (ClearCLImageInterface)cl_pos, 0.0, StatisticsOfLabelledPixels.STATISTICS_ENTRY.CENTROID_X.value);
        clij2.paste((ClearCLImageInterface)cl_pos, (ClearCLImageInterface)output, 0.0, 0.0);
        clij2.crop((ClearCLImageInterface)table, (ClearCLImageInterface)cl_pos, 0.0, StatisticsOfLabelledPixels.STATISTICS_ENTRY.CENTROID_Y.value);
        clij2.paste((ClearCLImageInterface)cl_pos, (ClearCLImageInterface)output, 0.0, 1.0);
        if (output.getHeight() > 2L) {
            clij2.crop((ClearCLImageInterface)table, (ClearCLImageInterface)cl_pos, 0.0, StatisticsOfLabelledPixels.STATISTICS_ENTRY.CENTROID_Z.value);
            clij2.paste((ClearCLImageInterface)cl_pos, (ClearCLImageInterface)output, 0.0, 2.0);
        }
        cl_pos.close();
        table.close();
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        long numberOfSpots = (long)this.getCLIJ2().getMaximumOfAllPixels((ClearCLImageInterface)input);
        return this.getCLIJ2().create(new long[]{numberOfSpots, input.getDimension()}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Determines centroids of all labels in a label map image and saves corresponding coordinates in a pointlist.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public static void main(String[] args) {
        CLIJ2 clij2 = CLIJ2.getInstance();
        ClearCLBuffer labelmap = clij2.pushString("1 2\n3 4");
        ClearCLBuffer pointlist = clij2.create(4L, 2L);
        LabelCentroidsToPointList.labelCentroidsToPointList(clij2, labelmap, pointlist);
        clij2.print((ClearCLImageInterface)pointlist);
    }
}

