/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.CountNonZeroPixels;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_labelledSpotsToPointList")
public class LabelledSpotsToPointList
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Label Image";
    }

    @Override
    public String getOutputType() {
        return "Pointlist";
    }

    public String getParameterHelpText() {
        return "Image input_labelled_spots, ByRef Image destination_pointlist";
    }

    public boolean executeCL() {
        return this.getCLIJ2().labelledSpotsToPointList((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
    }

    public static boolean labelledSpotsToPointList(CLIJ2 clij2, ClearCLBuffer input_labelmap, ClearCLBuffer output) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", input_labelmap);
        parameters.put("dst_point_list", output);
        long[] globalSizes = input_labelmap.getDimensions();
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(LabelledSpotsToPointList.class, "labelled_spots_to_point_list_x.cl", "labelled_spots_to_point_list", globalSizes, globalSizes, parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        long numberOfSpots = (long)CountNonZeroPixels.countNonZeroPixels(this.getCLIJ2(), input);
        return this.clij.create(new long[]{numberOfSpots, input.getDimension()}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Generates a coordinate list of points in a labelled spot image. \n\nTransforms a labelmap of spots (single pixels with values 1, 2, ..., n for n spots) as resulting \nfrom connected components analysis in an image where every column contains d \npixels (with d = dimensionality of the original image) with the coordinates of the maxima/minima.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Label, Measurements";
    }
}

