/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCL;
import net.haesleinhuepf.clij.clearcl.ClearCLDevice;
import net.haesleinhuepf.clij.clearcl.backend.ClearCLBackendInterface;
import net.haesleinhuepf.clij.clearcl.backend.ClearCLBackends;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_listAvailableGPUs")
public class ListAvailableGPUs
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        ResultsTable table = ResultsTable.getResultsTable();
        ClearCLBackendInterface lClearCLBackend = ClearCLBackends.getBestBackend();
        ClearCL lClearCL = new ClearCL(lClearCLBackend);
        for (ClearCLDevice lDevice : lClearCL.getAllDevices()) {
            table.incrementCounter();
            table.addValue("GPUName", lDevice.getName());
            table.addValue("Max_memory_in_bytes", (double)lDevice.getMaxMemoryAllocationSizeInBytes());
            table.addValue("OpenCL_version", lDevice.getVersion());
            table.addValue("Clock_frequency", (double)lDevice.getClockFrequency());
            table.addValue("Number_of_compute_units", (double)lDevice.getNumberOfComputeUnits());
            table.addValue("Global_memory_in_bytes", (double)lDevice.getGlobalMemorySizeInBytes());
            table.addValue("Local_memory_in_bytes", (double)lDevice.getLocalMemorySizeInBytes());
            table.addValue("Max_workgroup_size", (double)lDevice.getMaxWorkGroupSize());
            table.addValue("Extensions", lDevice.getExtensions());
            table.addValue("Info", lDevice.getInfoString());
            table.show("Results");
        }
        return true;
    }

    public String getParameterHelpText() {
        return "";
    }

    public String getDescription() {
        return "Reads out properties of the currently active GPU writes it to the results table in the columns 'GPUName', 'Memory_in_bytes' and 'OpenCL_Version'.";
    }

    public String getAvailableForDimensions() {
        return "";
    }
}

