/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_mask")
public class Mask
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image, Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        return this.getCLIJ2().mask((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]));
    }

    public static boolean mask(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface mask, ClearCLImageInterface dst) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)mask, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("mask", mask);
        parameters.put("dst", dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (mask)");
        }
        clij2.execute(Mask.class, "mask_" + src.getDimension() + "d_x.cl", "mask_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, Image mask, ByRef Image destination";
    }

    public String getDescription() {
        return "Computes a masked image by applying a binary mask to an image. \n\nAll pixel values x of image X will be copied\nto the destination image in case pixel value m at the same position in the mask image is not equal to \nzero.\n\n<pre>f(x,m) = (x if (m != 0); (0 otherwise))</pre>";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Binary, Filter";
    }
}

