/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_matrixEqual")
public class MatrixEqual
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getParameterHelpText() {
        return "Image input1, Image input2, Number tolerance";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().matrixEqual((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], MatrixEqual.asFloat((Object)this.args[2]).floatValue());
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("MatrixEqual", result ? 1.0 : 0.0);
        return result;
    }

    public static boolean matrixEqual(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer buffer2, Float tolerance) {
        if (buffer1.getWidth() != buffer2.getWidth() || buffer1.getHeight() != buffer2.getHeight() || buffer1.getDepth() != buffer2.getDepth()) {
            System.out.println("Sizes different");
            return false;
        }
        ClearCLBuffer diffBuffer = clij2.create(buffer1.getDimensions(), NativeTypeEnum.Float);
        clij2.addImagesWeighted((ClearCLImageInterface)buffer1, (ClearCLImageInterface)buffer2, (ClearCLImageInterface)diffBuffer, 1.0, -1.0);
        double maxDifference = clij2.maximumOfAllPixels((ClearCLImageInterface)diffBuffer);
        double minDifference = clij2.minimumOfAllPixels((ClearCLImageInterface)diffBuffer);
        diffBuffer.close();
        if (Math.abs(maxDifference) > (double)tolerance.floatValue() || Math.abs(minDifference) > (double)tolerance.floatValue()) {
            System.out.println("Difference unequal to zero!");
            return false;
        }
        return true;
    }

    public String getDescription() {
        return "Checks if all elements of a matrix are different by less than or equal to a given tolerance. \n\nThe result will be put in the results table in column \"MatrixEqual\" as 1 if yes and 0 otherwise.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Math";
    }
}

