/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_maximumOctagon")
public class MaximumOctagon
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        return this.getCLIJ2().maximumOctagon((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], MaximumOctagon.asInteger((Object)this.args[2]).intValue());
    }

    public static boolean maximumOctagon(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Integer iterations) {
        ClearCLImage flip = clij2.create(dst.getDimensions(), CLIJUtilities.nativeToChannelType(dst.getNativeType()));
        ClearCLImage flop = clij2.create(flip);
        ClearCLKernel flipKernel = null;
        ClearCLKernel flopKernel = null;
        clij2.copy((ClearCLImageInterface)src, (ClearCLImageInterface)flip);
        for (int i = 0; i < iterations; ++i) {
            if (i % 2 == 0) {
                flipKernel = MaximumOctagon.maximumBox(clij2, (ClearCLImageInterface)flip, (ClearCLImageInterface)flop, flipKernel);
                continue;
            }
            flopKernel = MaximumOctagon.maximumDiamond(clij2, (ClearCLImageInterface)flop, (ClearCLImageInterface)flip, flopKernel);
        }
        if (iterations % 2 == 0) {
            clij2.copy((ClearCLImageInterface)flip, (ClearCLImageInterface)dst);
        } else {
            clij2.copy((ClearCLImageInterface)flop, (ClearCLImageInterface)dst);
        }
        if (flipKernel != null) {
            flipKernel.close();
        }
        if (flopKernel != null) {
            flopKernel.close();
        }
        flip.close();
        flop.close();
        return true;
    }

    @Deprecated
    public static ClearCLKernel maximumBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, ClearCLKernel kernel) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        return clij2.executeSubsequently(MaximumOctagon.class, "maximum_octagon_box_" + src.getDimension() + "d_x.cl", "maximum_octagon_box_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters, kernel);
    }

    @Deprecated
    public static ClearCLKernel maximumDiamond(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, ClearCLKernel kernel) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        return clij2.executeSubsequently(MaximumOctagon.class, "maximum_octagon_diamond_" + src.getDimension() + "d_x.cl", "maximum_octagon_diamond_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters, kernel);
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number iterations";
    }

    public String getDescription() {
        return "Applies a maximum filter with kernel size 3x3 n times to an image iteratively. \n\nOdd iterations are done with box neighborhood, even iterations with a diamond. \nThus, with n > 2, the filter shape is an octagon. The given number of iterations makes the filter \nresult very similar to minimum sphere. Approximately:radius = iterations - 2";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Filter";
    }
}

