/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_maximumOfAllPixels")
public class MaximumOfAllPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        double maximumGreyValue = this.getCLIJ2().maximumOfAllPixels((ClearCLImageInterface)((ClearCLBuffer)this.args[0]));
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Max", maximumGreyValue);
        table.show("Results");
        return true;
    }

    public static double maximumOfAllPixels(CLIJ2 clij2, ClearCLImageInterface clImage) {
        ClearCLImageInterface clReducedImage = clImage;
        ClearCLImageInterface clReducedImage2 = clImage;
        if (clImage.getDimension() == 3L) {
            clReducedImage = clij2.create(new long[]{clImage.getWidth(), clImage.getHeight()}, clImage.getNativeType());
            clij2.maximumZProjection(clImage, clReducedImage);
        }
        if (clReducedImage.getDimension() == 2L) {
            clReducedImage2 = clij2.create(new long[]{clReducedImage.getWidth(), 1L}, clImage.getNativeType());
            clij2.maximumYProjection(clReducedImage, clReducedImage2);
        }
        ClearCLBuffer clReducedImage3 = clij2.create(new long[]{1L, 1L}, clij2.Float);
        clij2.maximumXProjection(clReducedImage2, (ClearCLImageInterface)clReducedImage3);
        float[] arr = new float[1];
        FloatBuffer buffer = FloatBuffer.wrap(arr);
        clReducedImage3.writeTo((Buffer)buffer, true);
        clij2.release((ClearCLImageInterface)clReducedImage3);
        double maximumGreyValue = arr[0];
        if (clImage != clReducedImage) {
            clij2.release(clReducedImage);
        }
        if (clImage != clReducedImage2) {
            clij2.release(clReducedImage2);
        }
        return maximumGreyValue;
    }

    public String getParameterHelpText() {
        return "Image source";
    }

    public String getDescription() {
        return "Determines the maximum of all pixels in a given image. \n\nIt will be stored in a new row of ImageJs\nResults table in the column 'Max'.\n\nParameters\n----------\nsource : Image\n    The image of which the maximum of all pixels or voxels will be determined.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

