/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_mean3DSphere")
public class Mean3DSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Filter, Noise";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 10, 10, 10};
    }

    public boolean executeCL() {
        int radiusX = Mean3DSphere.asInteger((Object)this.args[2]);
        int radiusY = Mean3DSphere.asInteger((Object)this.args[3]);
        int radiusZ = Mean3DSphere.asInteger((Object)this.args[4]);
        return this.getCLIJ2().mean3DSphere((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), radiusX, radiusY, radiusZ);
    }

    public static boolean mean3DSphere(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY, Integer radiusZ) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("Nx", CLIJUtilities.radiusToKernelSize((int)radiusX));
        parameters.put("Ny", CLIJUtilities.radiusToKernelSize((int)radiusY));
        parameters.put("Nz", CLIJUtilities.radiusToKernelSize((int)radiusZ));
        clij2.execute(Mean3DSphere.class, "mean_sphere_3d_x.cl", "mean_sphere_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radius_x, Number radius_y, Number radius_z";
    }

    public String getDescription() {
        return "Computes the local mean average of a pixels spherical neighborhood. \n\nThe spheres size is specified by \nits half-width, half-height and half-depth (radius).";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

