/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.CountNonZeroPixels;
import net.haesleinhuepf.clij2.plugins.GenerateDistanceMatrix;
import net.haesleinhuepf.clij2.plugins.ShortestDistances;
import net.haesleinhuepf.clij2.plugins.SpotsToPointList;
import net.haesleinhuepf.clij2.plugins.TransposeXY;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_meanClosestSpotDistance")
public class MeanClosestSpotDistance
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        ClearCLBuffer buffer1 = (ClearCLBuffer)this.args[0];
        ClearCLBuffer buffer2 = (ClearCLBuffer)this.args[1];
        Boolean bidirectional = MeanClosestSpotDistance.asBoolean((Object)this.args[2]);
        double[] minimumDistances = this.getCLIJ2().meanClosestSpotDistance(buffer1, buffer2, bidirectional);
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("mean_closest_spot_distance_A_B", minimumDistances[0]);
        if (bidirectional.booleanValue()) {
            table.addValue("mean_closest_spot_distance_B_A", minimumDistances[1]);
        }
        table.show("Results");
        return true;
    }

    public static double meanClosestSpotDistance(CLIJ2 clij2, ClearCLBuffer spotsA, ClearCLBuffer spotsB) {
        return MeanClosestSpotDistance.meanClosestSpotDistance(clij2, spotsA, spotsB, false)[0];
    }

    public static double[] meanClosestSpotDistance(CLIJ2 clij2, ClearCLBuffer spotsA, ClearCLBuffer spotsB, Boolean bidirectional) {
        double[] meanDistances = new double[bidirectional != false ? 2 : 1];
        long numberOfSpots1 = (long)CountNonZeroPixels.countNonZeroPixels(clij2, spotsA);
        ClearCLBuffer pointlist1 = clij2.create(new long[]{numberOfSpots1, spotsA.getDimension()}, NativeTypeEnum.Float);
        SpotsToPointList.spotsToPointList(clij2, spotsA, pointlist1);
        long numberOfSpots2 = (long)CountNonZeroPixels.countNonZeroPixels(clij2, spotsB);
        ClearCLBuffer pointlist2 = clij2.create(new long[]{numberOfSpots2, spotsA.getDimension()}, NativeTypeEnum.Float);
        SpotsToPointList.spotsToPointList(clij2, spotsB, pointlist2);
        ClearCLBuffer distanceMatrix = clij2.create(new long[]{numberOfSpots1 + 1L, numberOfSpots2 + 1L}, NativeTypeEnum.Float);
        GenerateDistanceMatrix.generateDistanceMatrix(clij2, pointlist1, pointlist2, distanceMatrix);
        pointlist1.close();
        pointlist2.close();
        ClearCLBuffer result = clij2.create(new long[]{distanceMatrix.getWidth(), 1L}, distanceMatrix.getNativeType());
        ShortestDistances.shortestDistances(clij2, distanceMatrix, result);
        meanDistances[0] = clij2.sumPixels((ClearCLImageInterface)result) / (double)(result.getWidth() - 1L) / (double)result.getHeight() / (double)result.getDepth();
        System.out.println("mean distance A B: " + meanDistances[0]);
        result.close();
        if (bidirectional.booleanValue()) {
            ClearCLBuffer transposedMatrix = clij2.create(new long[]{distanceMatrix.getHeight(), distanceMatrix.getWidth()}, distanceMatrix.getNativeType());
            TransposeXY.transposeXY(clij2, distanceMatrix, transposedMatrix);
            ClearCLBuffer result2 = clij2.create(new long[]{transposedMatrix.getWidth(), 1L}, transposedMatrix.getNativeType());
            ShortestDistances.shortestDistances(clij2, transposedMatrix, result2);
            meanDistances[1] = clij2.sumPixels((ClearCLImageInterface)result2) / (double)result2.getWidth() / (double)result2.getHeight() / (double)result2.getDepth();
            System.out.println("mean distance B A: " + meanDistances[1]);
            transposedMatrix.close();
        }
        distanceMatrix.close();
        return meanDistances;
    }

    public String getParameterHelpText() {
        return "Image spotsA, Image spotsB, Boolean bidirectional";
    }

    public String getDescription() {
        return "Determines the distance between pairs of closest spots in two binary images. \n\nTakes two binary images A and B with marked spots and determines for each spot in image A the closest spot in image B. Afterwards, it saves the average shortest distances from image A to image B as 'mean_closest_spot_distance_A_B' and from image B to image A as 'mean_closest_spot_distance_B_A' to the results table. The distance between B and A is only determined if the `bidirectional` checkbox is checked.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

