/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.EqualConstant;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_meanOfMaskedPixels")
public class MeanOfMaskedPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Binary, Measurements";
    }

    public boolean executeCL() {
        double minVal = this.getCLIJ2().meanOfMaskedPixels((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Masked_mean", minVal);
        table.show("Results");
        return true;
    }

    public static double meanOfMaskedPixels(CLIJ2 clij2, ClearCLBuffer clImage, ClearCLBuffer mask) {
        ClearCLBuffer tempBinary = clij2.create(clImage);
        ClearCLBuffer tempMultiplied = clij2.create(clImage);
        EqualConstant.equalConstant(clij2, (ClearCLImageInterface)mask, (ClearCLImageInterface)tempBinary, Float.valueOf(1.0f));
        clij2.mask((ClearCLImageInterface)clImage, (ClearCLImageInterface)tempBinary, (ClearCLImageInterface)tempMultiplied);
        double sum = clij2.sumPixels((ClearCLImageInterface)tempMultiplied);
        double count = clij2.sumPixels((ClearCLImageInterface)tempBinary);
        clij2.release((ClearCLImageInterface)tempBinary);
        clij2.release((ClearCLImageInterface)tempMultiplied);
        return sum / count;
    }

    public String getParameterHelpText() {
        return "Image source, Image mask";
    }

    public String getDescription() {
        return "Determines the mean intensity in a masked image. \n\nOnly in pixels which have non-zero values in another binary mask image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

