/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.GreaterConstant;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_meanOfPixelsAboveThreshold")
public class MeanOfPixelsAboveThreshold
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        double minVal = this.getCLIJ2().meanOfPixelsAboveThreshold((ClearCLBuffer)this.args[0], MeanOfPixelsAboveThreshold.asFloat((Object)this.args[1]).floatValue());
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Mean_of_pixels_above_threshold", minVal);
        table.show("Results");
        return true;
    }

    public static double meanOfPixelsAboveThreshold(CLIJ2 clij2, ClearCLBuffer clImage, Float threshold) {
        ClearCLBuffer tempBinary = clij2.create(clImage);
        ClearCLBuffer tempMultiplied = clij2.create(clImage);
        GreaterConstant.greaterConstant(clij2, (ClearCLImageInterface)clImage, (ClearCLImageInterface)tempBinary, threshold);
        clij2.mask((ClearCLImageInterface)clImage, (ClearCLImageInterface)tempBinary, (ClearCLImageInterface)tempMultiplied);
        double sum = clij2.sumPixels((ClearCLImageInterface)tempMultiplied);
        double count = clij2.sumPixels((ClearCLImageInterface)tempBinary);
        clij2.release((ClearCLImageInterface)tempBinary);
        clij2.release((ClearCLImageInterface)tempMultiplied);
        return sum / count;
    }

    public String getParameterHelpText() {
        return "Image source, Number threshold";
    }

    public String getDescription() {
        return "Determines the mean intensity in a threshleded image. \n\nBut only in pixels which are above a given threshold.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

