/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_meanSliceBySliceSphere")
public class MeanSliceBySliceSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 10, 10};
    }

    public boolean executeCL() {
        int radiusX = MeanSliceBySliceSphere.asInteger((Object)this.args[2]);
        int radiusY = MeanSliceBySliceSphere.asInteger((Object)this.args[3]);
        return this.getCLIJ2().meanSliceBySliceSphere((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), radiusX, radiusY);
    }

    public static boolean meanSliceBySliceSphere(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("Nx", CLIJUtilities.radiusToKernelSize((int)radiusX));
        parameters.put("Ny", CLIJUtilities.radiusToKernelSize((int)radiusY));
        clij2.execute(MeanSliceBySliceSphere.class, "mean_slice_by_slice_sphere_3d_x.cl", "mean_slice_by_slice_sphere_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radiusX, Number radiusY";
    }

    public String getDescription() {
        return "Computes the local mean average of a pixels ellipsoidal 2D neighborhood in an image stack \nslice by slice. \n\nThe ellipses size is specified by its half-width and half-height (radius).\n\nThis filter is applied slice by slice in 2D.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getCategories() {
        return "Filter";
    }
}

