/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_meanSquaredError")
public class MeanSquaredError
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        double meanSquaredError = 0.0;
        ClearCLBuffer buffer1 = (ClearCLBuffer)this.args[0];
        ClearCLBuffer buffer2 = (ClearCLBuffer)this.args[1];
        meanSquaredError = this.getCLIJ2().meanSquaredError(buffer1, buffer2);
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("MSE", meanSquaredError);
        table.show("Results");
        return true;
    }

    public static double meanSquaredError(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer buffer2) {
        ClearCLBuffer difference = clij2.create(buffer1.getDimensions(), NativeTypeEnum.Float);
        ClearCLBuffer squared = clij2.create(buffer1.getDimensions(), NativeTypeEnum.Float);
        clij2.subtractImages((ClearCLImageInterface)buffer1, (ClearCLImageInterface)buffer2, (ClearCLImageInterface)difference);
        clij2.power((ClearCLImageInterface)difference, (ClearCLImageInterface)squared, 2.0);
        double mse = clij2.sumOfAllPixels((ClearCLImageInterface)squared) / (double)squared.getWidth() / (double)squared.getHeight() / (double)squared.getDepth();
        difference.close();
        squared.close();
        return mse;
    }

    public String getParameterHelpText() {
        return "Image source1, Image source2";
    }

    public String getDescription() {
        return "Determines the mean squared error (MSE) between two images. \n\nThe MSE will be stored in a new row of ImageJs\nResults table in the column 'MSE'.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

