/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij.utilities.CLKernelExecutor;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_median2DSphere")
public class Median2DSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Filter, Noise";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 2};
    }

    public boolean executeCL() {
        int radiusX = Median2DSphere.asInteger((Object)this.args[2]);
        int radiusY = Median2DSphere.asInteger((Object)this.args[3]);
        return this.getCLIJ2().median2DSphere((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), radiusX, radiusY);
    }

    public static boolean median2DSphere(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        int kernelSizeX = CLIJUtilities.radiusToKernelSize((int)radiusX);
        int kernelSizeY = CLIJUtilities.radiusToKernelSize((int)radiusY);
        if (kernelSizeX * kernelSizeY > CLKernelExecutor.MAX_ARRAY_SIZE) {
            throw new IllegalArgumentException("Error: kernels of the medianSphere filter is too big. Consider increasing MAX_ARRAY_SIZE.");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("Nx", kernelSizeX);
        parameters.put("Ny", kernelSizeY);
        clij2.execute(Median2DSphere.class, "median_sphere_2d_x.cl", "median_sphere_2d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radiusX, Number radiusY";
    }

    public String getDescription() {
        return "Computes the local median of a pixels ellipsoidal neighborhood. \n\nThe ellipses size is specified by \nits half-width and half-height (radius).\n\nFor technical reasons, the area of the ellipse must have less than 1000 pixels.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

