/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij.utilities.CLKernelExecutor;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_median3DBox")
public class Median3DBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Filter, Noise";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 2, 2};
    }

    public boolean executeCL() {
        return this.getCLIJ2().median3DBox((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), Median3DBox.asInteger((Object)this.args[2]).intValue(), Median3DBox.asInteger((Object)this.args[3]).intValue(), Median3DBox.asInteger((Object)this.args[4]).intValue());
    }

    public static boolean median3DBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY, Integer radiusZ) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        int kernelSizeX = CLIJUtilities.radiusToKernelSize((int)radiusX);
        int kernelSizeY = CLIJUtilities.radiusToKernelSize((int)radiusY);
        int kernelSizeZ = CLIJUtilities.radiusToKernelSize((int)radiusZ);
        if (kernelSizeX * kernelSizeY * kernelSizeZ > CLKernelExecutor.MAX_ARRAY_SIZE) {
            throw new IllegalArgumentException("Error: kernels of the medianSphere filter is too big. Consider increasing MAX_ARRAY_SIZE.");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        parameters.put("Nx", kernelSizeX);
        parameters.put("Ny", kernelSizeY);
        parameters.put("Nz", kernelSizeZ);
        clij2.execute(Median3DBox.class, "median_box_3d_x.cl", "median_box_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radiusX, Number radiusY, Number radiusZ";
    }

    public String getDescription() {
        return "Computes the local median of a pixels cuboid neighborhood. \n\nThe cuboid size is specified by \nits half-width, half-height and half-depth (radius).\n\nFor technical reasons, the volume of the cuboid must contain less than 1000 voxels.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

