/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.Minimum3DBox;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_minimum2DBox")
public class Minimum2DBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Filter";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 10, 10};
    }

    public boolean executeCL() {
        int radiusX = Minimum2DBox.asInteger((Object)this.args[2]);
        int radiusY = Minimum2DBox.asInteger((Object)this.args[3]);
        return this.getCLIJ2().minimum2DBox((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), radiusX, radiusY);
    }

    public static boolean minimumBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY) {
        return Minimum3DBox.minimumBox(clij2, src, dst, radiusX, radiusY, 0);
    }

    public static boolean minimum2DBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY) {
        return Minimum3DBox.minimumBox(clij2, src, dst, radiusX, radiusY, 0);
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radius_x, Number radius_y";
    }

    public String getDescription() {
        return "Computes the local minimum of a pixels rectangular neighborhood. \n\nThe rectangles size is specified by \nits half-width and half-height (radius).";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

