/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clij2.utilities.ProcessableInTiles;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_minimum3DBox")
public class Minimum3DBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
ProcessableInTiles,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Filter";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 10, 10, 10};
    }

    public boolean executeCL() {
        int radiusX = Minimum3DBox.asInteger((Object)this.args[2]);
        int radiusY = Minimum3DBox.asInteger((Object)this.args[3]);
        int radiusZ = Minimum3DBox.asInteger((Object)this.args[4]);
        return this.getCLIJ2().minimum3DBox((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), radiusX, radiusY, radiusZ);
    }

    public static boolean minimum3DBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY, Integer radiusZ) {
        return Minimum3DBox.minimumBox(clij2, src, dst, radiusX, radiusY, radiusZ);
    }

    public static boolean minimumBox(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer radiusX, Integer radiusY, Integer radiusZ) {
        return CLIJUtilities.executeSeparableKernel(clij2, src, dst, Minimum3DBox.class, "minimum_separable_" + src.getDimension() + "d_x.cl", "minimum_separable_" + src.getDimension() + "d", net.haesleinhuepf.clij.utilities.CLIJUtilities.radiusToKernelSize((int)radiusX), net.haesleinhuepf.clij.utilities.CLIJUtilities.radiusToKernelSize((int)radiusY), net.haesleinhuepf.clij.utilities.CLIJUtilities.radiusToKernelSize((int)radiusZ), radiusX.intValue(), radiusY.intValue(), radiusZ.intValue(), src.getDimension());
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radius_x, Number radius_y, Number radius_z";
    }

    public String getDescription() {
        return "Computes the local minimum of a pixels cube neighborhood. \n\nThe cubes size is specified by \nits half-width, half-height and half-depth (radius).";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

