/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_minimumDistanceOfTouchingNeighbors")
public class MinimumDistanceOfTouchingNeighbors
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image, Matrix";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getParameterHelpText() {
        return "Image distance_matrix, Image touch_matrix, ByRef Image minimum_distancelist_destination";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().minimumDistanceOfTouchingNeighbors((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean minimumDistanceOfTouchingNeighbors(CLIJ2 clij2, ClearCLBuffer distance_matrix, ClearCLBuffer touch_matrix, ClearCLBuffer minimum_distancelist_destination) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_distance_matrix", distance_matrix);
        parameters.put("src_touch_matrix", touch_matrix);
        parameters.put("dst_distance_list", minimum_distancelist_destination);
        long[] globalSizes = new long[]{distance_matrix.getWidth()};
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(MinimumDistanceOfTouchingNeighbors.class, "minimum_distance_of_touching_neighbors_x.cl", "minimum_distance_of_touching_neighbors", globalSizes, globalSizes, parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(new long[]{input.getWidth(), 1L, 1L}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Takes a touch matrix and a distance matrix to determine the shortest distance of touching neighbors for every object.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }

    public String getCategories() {
        return "Graph, Measurements";
    }
}

