/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_minimumOfAllPixels")
public class MinimumOfAllPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        double minimumGreyValue = this.getCLIJ2().minimumOfAllPixels((ClearCLImageInterface)((ClearCLBuffer)this.args[0]));
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Min", minimumGreyValue);
        table.show("Results");
        return true;
    }

    public static double minimumOfAllPixels(CLIJ2 clij2, ClearCLImageInterface clImage) {
        ClearCLImageInterface clReducedImage = clImage;
        if (clImage.getDimension() == 3L) {
            clReducedImage = clij2.create(new long[]{clImage.getWidth(), clImage.getHeight()}, clImage.getNativeType());
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("src", clImage);
            parameters.put("dst", clReducedImage);
            clij2.execute(MinimumOfAllPixels.class, "minimum_projection_3d_2d_x.cl", "minimum_projection_3d_2d", clReducedImage.getDimensions(), clReducedImage.getDimensions(), parameters);
        }
        RandomAccessibleInterval rai = clij2.convert(clReducedImage, RandomAccessibleInterval.class);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
        float minimumGreyValue = Float.MAX_VALUE;
        while (cursor.hasNext()) {
            float greyValue = ((RealType)cursor.next()).getRealFloat();
            if (!(minimumGreyValue > greyValue)) continue;
            minimumGreyValue = greyValue;
        }
        if (clImage != clReducedImage) {
            clij2.release(clReducedImage);
        }
        return minimumGreyValue;
    }

    public String getParameterHelpText() {
        return "Image source";
    }

    public String getDescription() {
        return "Determines the minimum of all pixels in a given image. \n\nIt will be stored in a new row of ImageJs\nResults table in the column 'Min'.\n\nParameters\n----------\nsource : Image\n    The image of which the minimum of all pixels or voxels will be determined.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

