/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_multiplyImageAndCoordinate")
public class MultiplyImageAndCoordinate
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Math";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0};
    }

    public boolean executeCL() {
        return this.getCLIJ2().multiplyImageAndCoordinate((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), MultiplyImageAndCoordinate.asInteger((Object)this.args[2]).intValue());
    }

    public static boolean multiplyImageAndCoordinate(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer dimension) {
        net.haesleinhuepf.clij.utilities.CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dimension", dimension);
        parameters.put("dst", dst);
        if (!CLIJUtilities.checkDimensions(src.getDimension(), dst.getDimension())) {
            throw new IllegalArgumentException("Error: number of dimensions don't match! (multiplyImageAndCoordinate)");
        }
        clij2.execute(MultiplyImageAndCoordinate.class, "multiply_image_and_coordinate_" + src.getDimension() + "d_x.cl", "multiply_image_and_coordinate_" + src.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number dimension";
    }

    public String getDescription() {
        return "Multiplies all pixel intensities with the x, y or z coordinate, depending on specified dimension.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

