/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_multiplyStackWithPlane")
public class MultiplyStackWithPlane
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        return this.getCLIJ2().multiplyStackWithPlane((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), (ClearCLImageInterface)((ClearCLBuffer)this.args[2]));
    }

    public static boolean multiplyStackWithPlane(CLIJ2 clij2, ClearCLImageInterface input3d, ClearCLImageInterface input2d, ClearCLImageInterface output3d) {
        CLIJUtilities.assertDifferent((Object)input2d, (Object)output3d);
        CLIJUtilities.assertDifferent((Object)input3d, (Object)output3d);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", input3d);
        parameters.put("src1", input2d);
        parameters.put("dst", output3d);
        clij2.execute(MultiplyStackWithPlane.class, "multiply_stack_with_plane_3d_x.cl", "multiply_stack_with_plane_3d", output3d.getDimensions(), output3d.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image sourceStack, Image sourcePlane, ByRef Image destination";
    }

    public String getDescription() {
        return "Multiplies all pairs of pixel values x and y from an image stack X and a 2D image Y. \n\nx and y are at \nthe same spatial position within a plane.\n\n<pre>f(x, y) = x * y</pre>";
    }

    public String getAvailableForDimensions() {
        return "3D (first parameter), 2D (second parameter), 3D (result)";
    }
}

