/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_nClosestDistances")
public class NClosestDistances
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Graph, Measurements";
    }

    public String getParameterHelpText() {
        return "Image distance_matrix, ByRef Image distances_destination, ByRef Image indexlist_destination, Number nClosestPointsTofind";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().nClosestDistances((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean nClosestDistances(CLIJ2 clij2, ClearCLBuffer distance_matrix, ClearCLBuffer distancelist_destination, ClearCLBuffer indexlist_destination) {
        if (distancelist_destination.getHeight() > 1000L) {
            System.out.println("Warning: NClosestPoints is limited to n=1000 for technical reasons.");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_distancematrix", distance_matrix);
        parameters.put("dst_distancelist", distancelist_destination);
        parameters.put("dst_indexlist", indexlist_destination);
        long[] globalSizes = new long[]{distance_matrix.getWidth(), 1L, 1L};
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(NClosestDistances.class, "n_shortest_distances_x.cl", "find_n_closest_points", globalSizes, globalSizes, parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(new long[]{input.getWidth(), NClosestDistances.asInteger((Object)this.args[3]).intValue()}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Determine the n point indices with shortest distance for all points in a distance matrix. \n\nThis corresponds to the n row indices with minimum values for each column of the distance matrix.Returns the n shortest distances in one image and the point indices in another image.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

