/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_neighborsOfNeighbors")
public class NeighborsOfNeighbors
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Matrix";
    }

    @Override
    public String getOutputType() {
        return "Matrix";
    }

    public String getParameterHelpText() {
        return "Image touch_matrix, ByRef Image neighbor_matrix_destination";
    }

    public boolean executeCL() {
        ClearCLBuffer touch_matrix = (ClearCLBuffer)this.args[0];
        ClearCLBuffer neighbor_matrix = (ClearCLBuffer)this.args[1];
        return NeighborsOfNeighbors.neighborsOfNeighbors(this.getCLIJ2(), touch_matrix, neighbor_matrix);
    }

    public static boolean neighborsOfNeighbors(CLIJ2 clij2, ClearCLBuffer touch_matrix, ClearCLBuffer neighbor_matrix) {
        ClearCLBuffer adjacency_matrix = clij2.create(touch_matrix);
        clij2.touchMatrixToAdjacencyMatrix(touch_matrix, adjacency_matrix);
        ClearCLBuffer temp = clij2.create(touch_matrix);
        clij2.multiplyMatrix(adjacency_matrix, adjacency_matrix, temp);
        clij2.greaterConstant((ClearCLImageInterface)temp, (ClearCLImageInterface)adjacency_matrix, 0.0);
        clij2.adjacencyMatrixToTouchMatrix(adjacency_matrix, neighbor_matrix);
        adjacency_matrix.close();
        temp.close();
        return true;
    }

    public String getDescription() {
        return "Determines neighbors of neigbors from touch matrix and saves the result as a new touch matrix.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Graph, Filter";
    }
}

