/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLKernel;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_onlyzeroOverwriteMaximumDiamond")
public class OnlyzeroOverwriteMaximumDiamond
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        ClearCLBuffer flag = this.clij.create(new long[]{1L, 1L, 1L}, output.getNativeType());
        boolean result = this.getCLIJ2().onlyzeroOverwriteMaximumDiamond((ClearCLImageInterface)input, (ClearCLImageInterface)flag, (ClearCLImageInterface)output);
        flag.close();
        return result;
    }

    public static ClearCLKernel onlyzeroOverwriteMaximumDiamond(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface flag, ClearCLImageInterface dst, ClearCLKernel kernel) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("flag_dst", flag);
        parameters.put("dst", dst);
        kernel = clij2.executeSubsequently(OnlyzeroOverwriteMaximumDiamond.class, "onlyzero_overwrite_maximum_diamond_" + dst.getDimension() + "d_x.cl", "onlyzero_overwrite_maximum_diamond_" + dst.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters, kernel);
        return kernel;
    }

    public static boolean onlyzeroOverwriteMaximumDiamond(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface flag, ClearCLImageInterface dst) {
        ClearCLKernel kernel = OnlyzeroOverwriteMaximumDiamond.onlyzeroOverwriteMaximumDiamond(clij2, src, flag, dst, null);
        kernel.close();
        return true;
    }

    public static boolean onlyzeroOverwriteMaximumDiamond(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst) {
        ClearCLBuffer flag = clij2.create(1L, 1L, 1L);
        ClearCLKernel kernel = OnlyzeroOverwriteMaximumDiamond.onlyzeroOverwriteMaximumDiamond(clij2, src, (ClearCLImageInterface)flag, dst, null);
        kernel.close();
        flag.close();
        return true;
    }

    public String getDescription() {
        return "Apply a local maximum filter to an image which only overwrites pixels with value 0.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

