/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_paste3D")
public class Paste3D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0, 0, 0};
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().paste((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), Paste3D.asInteger((Object)this.args[2]).intValue(), Paste3D.asInteger((Object)this.args[3]).intValue(), Paste3D.asInteger((Object)this.args[4]).intValue());
        return result;
    }

    public static boolean paste3D(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer destination_x, Integer destination_y, Integer destination_z) {
        return Paste3D.paste(clij2, src, dst, destination_x, destination_y, destination_z);
    }

    public static boolean paste(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer destination_x, Integer destination_y, Integer destination_z) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("destination_x", destination_x);
        parameters.put("destination_y", destination_y);
        if (dst.getDimension() > 2L) {
            parameters.put("destination_z", destination_z);
        }
        parameters.put("dst", dst);
        clij2.execute(Paste3D.class, "paste_" + dst.getDimension() + "d_x.cl", "paste_" + dst.getDimension() + "d", src.getDimensions(), src.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number destination_x, Number destination_y, Number destination_z";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int x = Paste3D.asInteger((Object)this.args[2]);
        int y = Paste3D.asInteger((Object)this.args[3]);
        int z = Paste3D.asInteger((Object)this.args[4]);
        return this.clij.createCLBuffer(new long[]{input.getWidth() + (long)x, input.getHeight() + (long)y, input.getDepth() + (long)z}, input.getNativeType());
    }

    public String getDescription() {
        return "Pastes an image into another image at a given position.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

